/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.interpreter.phpIni;

import com.aptana.php.debug.ui.phpini.INIFileSection;
import com.aptana.php.debug.ui.phpini.IPhpIniFileModifier;
import com.aptana.php.debug.ui.phpini.PHPIniEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIFileModifier
implements IPhpIniFileModifier {
    private static final String GLOBAL_SECTION = "__global__";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");
    private static final Pattern NAME_VAL_PATTERN = Pattern.compile("^;?\\s*((?:\\w|_|\\.)+)\\s*=\\s*(.*)");
    private File configFile;
    private List<INIFileSection> sections;
    private boolean isDirty;

    public INIFileModifier(String configFile) throws IOException {
        this(new File(configFile));
    }

    public INIFileModifier(File configFile) throws IOException {
        this.configFile = configFile;
        this.sections = new LinkedList<INIFileSection>();
        this.read();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addEntry(String name, String value, boolean replace) {
        this.addEntry(GLOBAL_SECTION, name, value, replace, null);
    }

    public void addEntry(String name, String value) {
        this.addEntry(GLOBAL_SECTION, name, value, false, null);
    }

    public void addEntry(String sectionName, String name, String value) {
        this.addEntry(sectionName, name, value, false, null);
    }

    public void insertEntry(PHPIniEntry before, String name, String value) {
        if (before == null || name == null || value == null) {
            throw new NullPointerException();
        }
        value = value.trim();
        INIFileSection section = before.getSection();
        int lineIndex = this.getEntryLineIndex(before);
        if (lineIndex == -1) {
            return;
        }
        int entryIndex = this.getEntryIndex(before);
        if (entryIndex == -1) {
            return;
        }
        section.getLines().add(lineIndex, String.valueOf(name) + '=' + value);
        section.getEntries().add(entryIndex, new PHPIniEntry(name, value, section));
        this.isDirty = true;
    }

    public void insertEntryToSectionBeginning(INIFileSection section, String name, String value) {
        if (section == null || name == null || value == null) {
            throw new NullPointerException();
        }
        section.getLines().add(0, String.valueOf(name) + '=' + value);
        section.getEntries().add(0, new PHPIniEntry(name, value, section));
        this.isDirty = true;
    }

    public void addEntry(String sectionName, String name, String value, boolean replace, String replacePattern) {
        if (sectionName == null || name == null || value == null) {
            throw new NullPointerException();
        }
        value = value.trim();
        for (INIFileSection section : this.sections) {
            if (!section.getName().equals(sectionName)) continue;
            if (replace) {
                int i = 0;
                while (i < section.getLines().size()) {
                    Matcher m = NAME_VAL_PATTERN.matcher((CharSequence)section.getLines().get(i));
                    if (m.matches()) {
                        String oldName = m.group(1);
                        String oldValue = Pattern.quote(m.group(2));
                        if (oldName.equals(name) && (replacePattern == null || oldValue.equals(replacePattern))) {
                            section.getLines().set(i, String.valueOf(name) + '=' + value);
                        }
                    }
                    ++i;
                }
                String val = value;
                for (PHPIniEntry entry : section.getEntries()) {
                    if (!entry.getKey().equals(name) || !Pattern.quote(entry.getValue()).equals(replacePattern)) continue;
                    entry.setValue(val);
                }
                break;
            }
            section.getEntries().add(new PHPIniEntry(name, value, section));
            section.getLines().add(String.valueOf(name) + '=' + value);
            break;
        }
        this.isDirty = true;
    }

    public boolean removeEntry(String name, String removePattern) {
        return this.removeEntry(GLOBAL_SECTION, name, removePattern);
    }

    public boolean removeAllEntries(String name) {
        return this.removeEntry(null, name, null);
    }

    public boolean removeAllEntries(String name, String removePattern) {
        return this.removeEntry(null, name, removePattern);
    }

    public boolean removeEntry(String sectionName, String name, String removePattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        for (INIFileSection section : this.sections) {
            if (sectionName != null && !section.getName().equals(sectionName)) continue;
            int i = 0;
            while (i < section.getLines().size()) {
                Matcher m = NAME_VAL_PATTERN.matcher((CharSequence)section.getLines().get(i));
                if (m.matches()) {
                    String oldName = m.group(1);
                    String oldValue = Pattern.quote(m.group(2));
                    if (oldName.equals(name) && (removePattern == null || oldValue.equals(removePattern))) {
                        section.getLines().remove(i--);
                        removed = true;
                    }
                }
                ++i;
            }
            ArrayList<PHPIniEntry> toRemove = new ArrayList<PHPIniEntry>();
            for (PHPIniEntry entry : section.getEntries()) {
                if (!entry.getKey().equals(name) || removePattern == null || !Pattern.quote(entry.getValue()).equals(removePattern)) continue;
                toRemove.add(entry);
            }
            section.getEntries().removeAll(toRemove);
            if (sectionName != null) break;
        }
        this.isDirty = true;
        return removed;
    }

    public List<INIFileSection> getSections() {
        return this.sections;
    }

    public void commentEntry(String name, String commentPattern) {
        this.commentEntry(GLOBAL_SECTION, name, commentPattern);
        this.isDirty = true;
    }

    public void commentAllEntries(String name, String commentPattern) {
        this.commentEntry(null, name, commentPattern);
        this.isDirty = true;
    }

    public void commentEntry(String sectionName, String name, String commentPattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (INIFileSection section : this.sections) {
            if (sectionName != null && !section.getName().equals(sectionName)) continue;
            List lines = section.getLines();
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.get(i);
                Matcher m = NAME_VAL_PATTERN.matcher(line);
                if (m.matches()) {
                    String oldName = m.group(1);
                    String oldValue = Pattern.quote(m.group(2));
                    if (!line.startsWith(";") && oldName.equals(name) && (commentPattern == null || oldValue.equals(commentPattern))) {
                        lines.set(i, String.valueOf(';') + line);
                    }
                }
                ++i;
            }
            for (PHPIniEntry entry : section.getEntries()) {
                if (!entry.getKey().equals(name) || entry.getCommented() || commentPattern != null && !Pattern.quote(entry.getValue()).equals(commentPattern)) continue;
                entry.setCommented(true);
            }
            if (sectionName != null) break;
        }
        this.isDirty = true;
    }

    public void uncommentEntry(String sectionName, String name, String commentPattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (INIFileSection section : this.sections) {
            if (sectionName != null && !section.getName().equals(sectionName)) continue;
            int i = 0;
            while (i < section.getLines().size()) {
                String line = (String)section.getLines().get(i);
                Matcher m = NAME_VAL_PATTERN.matcher(line);
                if (m.matches()) {
                    String oldName = m.group(1);
                    String oldValue = Pattern.quote(m.group(2));
                    if (line.startsWith(";") && oldName.equals(name) && (commentPattern == null || oldValue.equals(commentPattern))) {
                        int index = 1;
                        while (index < line.length()) {
                            if (!Character.isWhitespace(line.charAt(index))) break;
                            ++index;
                        }
                        section.getLines().set(i, line.substring(index));
                    }
                }
                ++i;
            }
            for (PHPIniEntry entry : section.getEntries()) {
                if (!entry.getKey().equals(name) || !entry.getCommented() || commentPattern != null && !Pattern.quote(entry.getValue()).equals(commentPattern)) continue;
                entry.setCommented(false);
            }
            if (sectionName != null) break;
        }
        this.isDirty = true;
    }

    protected void read() throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(this.configFile));
        INIFileSection currentSection = new INIFileSection(GLOBAL_SECTION);
        this.sections.add(currentSection);
        while ((line = r.readLine()) != null) {
            Matcher m = SECTION_PATTERN.matcher(line = line.trim());
            if (m.matches()) {
                String sectionName = m.group(1);
                currentSection = new INIFileSection(sectionName);
                this.sections.add(currentSection);
                continue;
            }
            Matcher entryMatcher = NAME_VAL_PATTERN.matcher(line);
            if (entryMatcher.matches()) {
                String val = entryMatcher.group(2).trim();
                PHPIniEntry entry = new PHPIniEntry(entryMatcher.group(1), val, currentSection);
                if (line.startsWith(";")) {
                    entry.setCommented(true);
                }
                currentSection.getEntries().add(entry);
            }
            currentSection.getLines().add(line);
        }
        r.close();
        this.isDirty = false;
    }

    public void flush() throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(this.configFile));
        for (INIFileSection section : this.sections) {
            if (section.getName() != GLOBAL_SECTION) {
                w.println(String.valueOf('[') + section.getName() + ']');
            }
            for (String line : section.getLines()) {
                w.println(line);
            }
        }
        w.close();
        this.isDirty = false;
    }

    public INIFileSection getSectionByName(String name) {
        for (INIFileSection section : this.sections) {
            if (!section.getName().equals(name)) continue;
            return section;
        }
        return null;
    }

    public INIFileSection getGlobalSection() {
        return this.getSectionByName(GLOBAL_SECTION);
    }

    public INIFileSection addSection(String sectionName) {
        INIFileSection currentSection = new INIFileSection(sectionName);
        this.sections.add(currentSection);
        this.isDirty = true;
        return currentSection;
    }

    public void removeSection(INIFileSection section) {
        this.sections.remove(section);
        this.isDirty = true;
    }

    public PHPIniEntry getEntryByName(String name) {
        if (name == null) {
            return null;
        }
        List<INIFileSection> allSections = this.getSections();
        for (INIFileSection section : allSections) {
            List entries = section.getEntries();
            for (PHPIniEntry entry : entries) {
                if (entry.getCommented() || !name.equals(entry.getKey())) continue;
                return entry;
            }
        }
        return null;
    }

    private int getEntryLineIndex(PHPIniEntry entry) {
        INIFileSection section = entry.getSection();
        int i = 0;
        while (i < section.getLines().size()) {
            String line = (String)section.getLines().get(i);
            Matcher m = NAME_VAL_PATTERN.matcher(line);
            if (m.matches()) {
                String name = m.group(1);
                String value = m.group(2);
                if (value != null) {
                    value = Pattern.quote(value);
                    if (name.equals(entry.getKey()) && value.equals(Pattern.quote(entry.getValue()))) {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    private int getEntryIndex(PHPIniEntry entry) {
        INIFileSection section = entry.getSection();
        return section.getEntries().indexOf(entry);
    }
}

